/*
 * Decompiled with CFR 0.152.
 */
package codersafterdark.reskillable.network;

import codersafterdark.reskillable.api.requirement.Requirement;
import codersafterdark.reskillable.api.requirement.RequirementCache;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class InvalidateRequirementPacket
implements IMessage,
IMessageHandler<InvalidateRequirementPacket, IMessage> {
    private Class<? extends Requirement>[] cacheTypes;
    private UUID uuid;

    public InvalidateRequirementPacket() {
    }

    public InvalidateRequirementPacket(UUID uuid, Class<? extends Requirement> ... cacheTypes) {
        this.uuid = uuid;
        this.cacheTypes = cacheTypes;
    }

    public void fromBytes(ByteBuf buf) {
        this.uuid = new UUID(buf.readLong(), buf.readLong());
        this.cacheTypes = new Class[buf.readInt()];
        for (int i = 0; i < this.cacheTypes.length; ++i) {
            try {
                Class<?> rClass = Class.forName(ByteBufUtils.readUTF8String((ByteBuf)buf));
                if (!Requirement.class.isAssignableFrom(rClass)) continue;
                this.cacheTypes[i] = rClass;
                continue;
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.uuid.getMostSignificantBits());
        buf.writeLong(this.uuid.getLeastSignificantBits());
        buf.writeInt(this.cacheTypes.length);
        for (Class<? extends Requirement> rClass : this.cacheTypes) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)rClass.getName());
        }
    }

    public IMessage onMessage(InvalidateRequirementPacket message, MessageContext ctx) {
        if (ctx.side.isServer()) {
            FMLCommonHandler.instance().getMinecraftServerInstance().func_152344_a(() -> this.handleMessage(message, ctx));
        } else {
            Minecraft.func_71410_x().func_152343_a(() -> this.handleMessage(message, ctx));
        }
        return null;
    }

    public IMessage handleMessage(InvalidateRequirementPacket message, MessageContext ctx) {
        if (message.cacheTypes.length == 0) {
            RequirementCache.getCache(message.uuid, ctx.side.isClient()).forceClear();
        } else {
            RequirementCache.invalidateCacheNoPacket(message.uuid, ctx.side.isClient(), message.cacheTypes);
        }
        return null;
    }
}

